/*
 * Dandelion Admin v1.0 - PickList JS
 *
 * This file is part of Dandelion Admin, an Admin template build for sale at ThemeForest.
 * For questions, suggestions or support request, please mail me at maimairel@yahoo.com
 *
 * Development Started:
 * March 25, 2012
 *
 * This file is a modified and simplified version of jquery-ui-picklist (http://code.google.com/p/jquery-ui-picklist/)
 * Changes:
 * - Changed the logic to refer option items from the list
 * - Removed the option to add rich items
 * - Removed the jquery.ui.widget dependency
 * - Removed all jquery ui class names
 * - Several code optimizations
 *
 * 'Highly configurable' mutable plugin boilerplate
 * Author: @markdalgleish
 * Further changes, comments: @addyosmani
 * Licensed under the MIT license
 *
 */

;(function(d,c,a,e){var b=function(g,f){this.element=d(g);this.options=f};b.prototype={defaults:{mainClass:"pickList",listContainerClass:"pickList_listContainer",sourceListContainerClass:"pickList_sourceListContainer",controlsContainerClass:"pickList_controlsContainer",targetListContainerClass:"pickList_targetListContainer",listClass:"pickList_list",sourceListClass:"pickList_sourceList",targetListClass:"pickList_targetList",listItemClass:"pickList_listItem",selectedListItemClass:"pickList_selectedListItem",addAllClass:"pickList_addAll",addClass:"pickList_add",removeAllClass:"pickList_removeAll",removeClass:"pickList_remove",addAllLabel:"&gt;&gt;",addLabel:"&gt;",removeAllLabel:"&lt;&lt;",removeLabel:"&lt;",sourceListLabel:"Available Options",targetListLabel:"Selected Options",listLabelClass:"pickList_listLabel",sourceListLabelClass:"pickList_sourceListLabel",targetListLabelClass:"pickList_targetListLabel"},init:function(){this.config=d.extend({},this.defaults,this.options);var f=this;f._buildPickList();f._refresh()},_buildPickList:function(){var f=this;f.pickList=d("<div></div>").hide().addClass(f.config.mainClass).insertAfter(f.element).append(f._buildSourceList()).append(f._buildControls()).append(f._buildTargetList());f._populateLists();f.element.hide();f.pickList.show()},_buildSourceList:function(){var g=this;var f=d("<div></div>").addClass(g.config.listContainerClass).addClass(g.config.sourceListContainerClass).css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none","-ms-user-select":"none"}).each(function(){this.onselectstart=function(){return false}});var h=d("<div></div>").text(g.config.sourceListLabel).addClass(g.config.listLabelClass).addClass(g.config.sourceListLabelClass);g.sourceList=d("<ul></ul>").addClass(g.config.listClass).addClass(g.config.sourceListClass).delegate("li","click",{pickList:g},g._changeHandler);f.append(h).append(g.sourceList);return f},_buildTargetList:function(){var g=this;var f=d("<div></div>").addClass(g.config.listContainerClass).addClass(g.config.targetListContainerClass).css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none","-ms-user-select":"none"}).each(function(){this.onselectstart=function(){return false}});var h=d("<div></div>").text(g.config.targetListLabel).addClass(g.config.listLabelClass).addClass(g.config.targetListLabelClass);g.targetList=d("<ul></ul>").addClass(g.config.listClass).addClass(g.config.targetListClass).delegate("li","click",{pickList:g},g._changeHandler);f.append(h).append(g.targetList);return f},_buildControls:function(){var f=this;f.controls=d("<div></div>").addClass(f.config.controlsContainerClass);f.addAllButton=d("<button></button>").click({pickList:f},f._addAllHandler).html(f.config.addAllLabel).addClass(f.config.addAllClass);f.addButton=d("<button></button>").click({pickList:f},f._addHandler).html(f.config.addLabel).addClass(f.config.addClass);f.removeButton=d("<button></button>").click({pickList:f},f._removeHandler).html(f.config.removeLabel).addClass(f.config.removeClass);f.removeAllButton=d("<button></button>").click({pickList:f},f._removeAllHandler).html(f.config.removeAllLabel).addClass(f.config.removeAllClass);f.controls.append(f.addAllButton).append(f.addButton).append(f.removeButton).append(f.removeAllButton);return f.controls},_populateLists:function(){var g=this,h=(g.element.get(0).selectedIndex<=0),f=g._generateRandomId();g.element.children().each(function(){var i=d(this).text();var j=d("<li/>").text(i).attr("id",f+"_"+d(this).index()).addClass(g.config.listItemClass);if(h||d(this).not(":selected")){g.sourceList.append(j)}else{g.targetList.append(j)}})},_addItem:function(g){var f=this;g.each(function(i,h){f.targetList.append(f._removeSelection(d(h)));itemId=d(h).attr("id");optionIndex=itemId.substr(itemId.lastIndexOf("_")+1);f.element.children("option").eq(optionIndex).attr("selected",true)})},_removeItem:function(g){var f=this;g.each(function(i,h){f.sourceList.append(f._removeSelection(d(h)));itemId=d(h).attr("id");optionIndex=itemId.substr(itemId.lastIndexOf("_")+1);f.element.children("option").eq(optionIndex).removeAttr("selected")})},_addAllHandler:function(g){var f=g.data.pickList;f._addItem(f.sourceList.children());f._refresh()},_addHandler:function(g){var f=g.data.pickList;f._addItem(f.sourceList.children(".pickList_selected"));f._refresh()},_removeHandler:function(g){var f=g.data.pickList;f._removeItem(f.targetList.children(".pickList_selected"));f._refresh()},_removeAllHandler:function(g){var f=g.data.pickList;f._removeItem(f.targetList.children());f._refresh()},_refresh:function(){var f=this;if(f.sourceList.children().length){f.addAllButton.removeAttr("disabled")}else{f.addAllButton.attr("disabled","disabled")}if(f.targetList.children().length){f.removeAllButton.removeAttr("disabled")}else{f.removeAllButton.attr("disabled","disabled")}if(f.sourceList.children(".pickList_selected").length){f.addButton.removeAttr("disabled")}else{f.addButton.attr("disabled","disabled")}if(f.targetList.children(".pickList_selected").length){f.removeButton.removeAttr("disabled")}else{f.removeButton.attr("disabled","disabled")}f._sortItems(f.sourceList);f._sortItems(f.targetList)},_sortItems:function(f){f.children().sort(function(h,g){return(h.innerHTML>g.innerHTML?1:(h.innerHTML==g.innerHTML?0:-1))}).appendTo(f)},_changeHandler:function(l){var h=l.data.pickList;if(l.ctrlKey){if(h._isSelected(d(this))){h._removeSelection(d(this))}else{h.lastSelectedItem=d(this);h._addSelection(d(this))}}else{if(l.shiftKey){var k=d(this).get(0);var j=h.lastSelectedItem.get(0);if(d(this).index()<d(h.lastSelectedItem).index()){var g=k;k=j;j=g}var i=false;var f=true;h._clearSelections(d(this).parent());d(this).parent().children().each(function(){if(d(this).get(0)==j){i=true}if(i&&f){h._addSelection(d(this))}if(d(this).get(0)==k){f=false}})}else{h.lastSelectedItem=d(this);h._clearSelections(d(this).parent());h._addSelection(d(this))}}h._refresh()},_isSelected:function(f){return f.hasClass("pickList_selected")},_addSelection:function(g){var f=this;return g.addClass("pickList_selected").addClass(f.config.selectedListItemClass)},_removeSelection:function(g){var f=this;return g.removeClass("pickList_selected").removeClass(f.config.selectedListItemClass)},_clearSelections:function(g){var f=this;g.children().each(function(){f._removeSelection(d(this))})},_generateRandomId:function(){var f="pickList_"+this._randomChar()+this._randomChar()+this._randomChar();while(d("#"+f).length>0){f+=this._randomChar()}return f},_randomChar:function(){var h,g,f;h="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";f=Math.floor(Math.random()*h.length);return h.substring(f,f+1)},destroy:function(){var f=this;f.pickList.remove();f.element.show()},};b.defaults=b.prototype.defaults;d.fn.daPickList=function(f){return this.each(function(){new b(this,f).init()})}})(jQuery,window,document);